package ru.yandex.solomon.expression.expr;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelExprRecurseVisitor implements SelExprVisitor {
    @Override
    public SelExpr visitValue(SelExprValue value) {
        return value;
    }

    @Override
    public SelExpr visitParam(SelExprParam param) {
        return param;
    }

    @Override
    public SelExpr visitOp(SelExprOpCall fnCall) {
        return visitNext(fnCall);
    }

    @Override
    public SelExpr visitFn(SelExprFuncCall fnCall) {
        return visitNext(fnCall);
    }

    @Override
    public SelExpr visitCondition(SelExprTern expr) {
        return visitNext(expr);
    }

    @Override
    public SelExpr visitInterpolatedString(SelExprInterpolatedString interpolatedString) {
        return interpolatedString;
    }

    @Override
    public SelExprSelector visitSelector(SelExprSelector selector) {
        return selector;
    }

    @Override
    public SelExpr visitSelectors(SelExprSelectors selectors) {
        return selectors;
    }

    @Override
    public SelExpr visitObject(SelExprObject object) {
        return visitNext(object);
    }

    private SelExpr visitNext(SelExpr root) {
        return root.mapParams(e -> e.visit(this));
    }
}
