package ru.yandex.solomon.expression.expr;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.ast.AstSelector;
import ru.yandex.solomon.expression.exceptions.EvaluationException;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.labels.query.SelectorType;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelExprSelector extends SelExpr {
    private final SelExpr key;
    private final SelExpr value;
    private final SelectorType type;

    public SelExprSelector(AstSelector ast, SelExpr key, SelExpr value, SelectorType type) {
        super(ast);
        this.key = key;
        this.value = value;
        this.type = type;
    }

    @Override
    public AstSelector getSourceAst() {
        return (AstSelector) super.getSourceAst();
    }

    public SelExpr getKey() {
        return key;
    }

    public SelExpr getValue() {
        return value;
    }

    public SelectorType getType() {
        return type;
    }

    @Nonnull
    @Override
    public SelType type() {
        return SelTypes.SELECTOR;
    }

    @Nonnull
    @Override
    protected SelValue evalInternal(EvalContextImpl context) {
        throw new EvaluationException(getRange(),
                "Not able evaluate selector: " + format());
    }

    @Override
    protected SelExpr mapParams(ParamsMapper f) {
        return null;
    }

    @Override
    public SelExpr visit(SelExprVisitor visitor) {
        return visitor.visitSelector(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SelExprSelector that = (SelExprSelector) o;
        return key.equals(that.key) &&
                value.equals(that.value) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, value, type);
    }

    @Override
    public String format() {
        return key.format() + " " + type.getOperator() + " " + value.format();
    }
}
