package ru.yandex.solomon.expression.expr;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.ast.AstSelectors;
import ru.yandex.solomon.expression.exceptions.EvaluationException;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.value.SelValue;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelExprSelectors extends SelExpr {
    private final SelType type;
    private final String nameSelector;
    private final List<SelExprSelector> selectors;

    public SelExprSelectors(AstSelectors ast, SelType type, String nameSelector, List<SelExprSelector> selectors) {
        super(ast);
        this.type = type;
        this.nameSelector = nameSelector;
        this.selectors = selectors;
    }

    @Override
    public AstSelectors getSourceAst() {
        return (AstSelectors) super.getSourceAst();
    }

    @Nonnull
    @Override
    public SelType type() {
        return type;
    }

    @Nonnull
    @Override
    public SelValue evalInternal(EvalContextImpl context) {
        throw new EvaluationException(getRange(),
            "Not able evaluate selector: " + selectors);
    }

    @Override
    protected SelExpr mapParams(ParamsMapper f) {
        return this;
    }

    @Override
    public SelExpr visit(SelExprVisitor visitor) {
        return visitor.visitSelectors(this);
    }

    @Override
    public String format() {
        return selectors.stream()
                .map(SelExprSelector::toString)
                .collect(Collectors.joining(", ", "{", "}"));
    }

    public String getNameSelector() {
        return nameSelector;
    }

    public List<SelExprSelector> getSelectors() {
        return selectors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SelExprSelectors that = (SelExprSelectors) o;
        return type.equals(that.type) &&
            nameSelector.equals(that.nameSelector) &&
            selectors.equals(that.selectors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, nameSelector, selectors);
    }
}
