package ru.yandex.solomon.expression.expr;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.value.SelValue;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelExprValue extends SelExpr {

    private final SelValue value;

    public SelExprValue(Ast ast, SelValue value) {
        super(ast);
        this.value = value;
    }

    @Nonnull
    @Override
    public SelType type() {
        return value.type();
    }

    @Nonnull
    @Override
    public SelValue evalInternal(EvalContextImpl context) {
        return value;
    }

    @Override
    protected SelExprValue mapParams(ParamsMapper f) {
        return this;
    }

    @Override
    public SelExpr visit(SelExprVisitor visitor) {
        return visitor.visitValue(this);
    }

    @Nonnull
    public SelValue getValue() {
        return value;
    }

    @Override
    public String format() {
        return value.format();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SelExprValue that = (SelExprValue) o;

        return value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

}
