package ru.yandex.solomon.expression.expr;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.solomon.expression.ExpressionMetrics;
import ru.yandex.solomon.expression.ast.AstCall;
import ru.yandex.solomon.expression.ast.AstIdent;
import ru.yandex.solomon.expression.expr.func.AggrSelFn;
import ru.yandex.solomon.expression.expr.func.DoubleSelFn;
import ru.yandex.solomon.expression.expr.func.GraphDataSelFnIntegrate;
import ru.yandex.solomon.expression.expr.func.SelFn0Random01;
import ru.yandex.solomon.expression.expr.func.SelFnConstantLine;
import ru.yandex.solomon.expression.expr.func.SelFnDeltaToRate;
import ru.yandex.solomon.expression.expr.func.SelFnDerivative;
import ru.yandex.solomon.expression.expr.func.SelFnDiff;
import ru.yandex.solomon.expression.expr.func.SelFnDropAbove;
import ru.yandex.solomon.expression.expr.func.SelFnDropBelow;
import ru.yandex.solomon.expression.expr.func.SelFnDropEmptyLines;
import ru.yandex.solomon.expression.expr.func.SelFnGridStep;
import ru.yandex.solomon.expression.expr.func.SelFnLoad;
import ru.yandex.solomon.expression.expr.func.SelFnLoad1;
import ru.yandex.solomon.expression.expr.func.SelFnMap;
import ru.yandex.solomon.expression.expr.func.SelFnMod;
import ru.yandex.solomon.expression.expr.func.SelFnNonNegativeDerivative;
import ru.yandex.solomon.expression.expr.func.SelFnPow;
import ru.yandex.solomon.expression.expr.func.SelFnRateToDelta;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.expr.func.aggr.SelFnPercentile;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnAllOf;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnAnyOf;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnAsap;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnBinomialDistribution;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnCrop;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnDropHead;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnDropIf;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnDropNan;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnDropTail;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnFilterByTime;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnGetTimestamps;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnGroupByLabels;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnGroupByTime;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnGroupLines;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnHead;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnKronosAdjusted;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnKronosMean;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnKronosVariance;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnMovingAvg;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnMovingPercentile;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnMovingSum;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnPercentileGroupLines;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnReplaceNan;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnSeasonalAdjusted;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnSeasonalMean;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnSeasonalVariance;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnShift;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnSingle;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnSize;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnTail;
import ru.yandex.solomon.expression.expr.func.analytical.SelFnTakeIf;
import ru.yandex.solomon.expression.expr.func.analytical.histogram.SelFnHistogramAvg;
import ru.yandex.solomon.expression.expr.func.analytical.histogram.SelFnHistogramCumulativeDistribution;
import ru.yandex.solomon.expression.expr.func.analytical.histogram.SelFnHistogramPercentile;
import ru.yandex.solomon.expression.expr.func.analytical.histogram.SelFnHistogramSum;
import ru.yandex.solomon.expression.expr.func.analytical.rank.SelFnRank;
import ru.yandex.solomon.expression.expr.func.analytical.sideEffect.SelFnStatusIf;
import ru.yandex.solomon.expression.expr.func.analytical.summary.SelFnSummaryExtract;
import ru.yandex.solomon.expression.expr.func.analytical.trends.SelFnExponentialTrend;
import ru.yandex.solomon.expression.expr.func.analytical.trends.SelFnLinearTrend;
import ru.yandex.solomon.expression.expr.func.analytical.trends.SelFnLogarithmicTrend;
import ru.yandex.solomon.expression.expr.func.string.SelFnToFixed;
import ru.yandex.solomon.expression.expr.func.string.SelFnToString;
import ru.yandex.solomon.expression.expr.func.util.SelFnAlertEvaluationHistory;
import ru.yandex.solomon.expression.expr.func.util.SelFnAlias;
import ru.yandex.solomon.expression.expr.func.util.SelFnAsVector;
import ru.yandex.solomon.expression.expr.func.util.SelFnEvalTimeInterval;
import ru.yandex.solomon.expression.expr.func.util.SelFnFallback;
import ru.yandex.solomon.expression.expr.func.util.SelFnFlatten;
import ru.yandex.solomon.expression.expr.func.util.SelFnGetLabel;
import ru.yandex.solomon.expression.expr.func.util.SelFnInf;
import ru.yandex.solomon.expression.expr.func.util.SelFnTimeInterval;
import ru.yandex.solomon.expression.expr.func.util.SelFnToVector;
import ru.yandex.solomon.expression.expr.func.util.SelFnTransform;
import ru.yandex.solomon.expression.version.SelVersion;

/**
 * @author Vladimir Gordiychuk
 */
public class SelFunctions {
    public static final SelFuncRegistry REGISTRY;

    static {
        SelFuncRegistry b = new SelFuncRegistry();

        b.add(new SelFn0Random01());
        for (var func : DoubleSelFn.Type.values()) {
            b.add(func.getFunc());
        }
        b.add(new SelFnPow());
        b.add(new SelFnMod());

        b.add(new SelFnSingle());
        b.add(new SelFnDerivative());
        b.add(new SelFnNonNegativeDerivative());
        b.add(new GraphDataSelFnIntegrate());
        b.add(new SelFnDiff());
        b.add(new SelFnAsap());
        b.add(new SelFnReplaceNan());
        b.add(new SelFnDropNan());
        b.add(new SelFnRank());
        b.add(new SelFnGroupByTime());
        b.add(new SelFnGroupLines());
        b.add(new SelFnPercentileGroupLines());
        b.add(new SelFnDropBelow());
        b.add(new SelFnDropAbove());
        b.add(new SelFnAnyOf());
        b.add(new SelFnAllOf());
        b.add(new SelFnTail());
        b.add(new SelFnHead());
        b.add(new SelFnDropTail());
        b.add(new SelFnDropHead());
        b.add(new SelFnSeasonalMean());
        b.add(new SelFnSeasonalVariance());
        b.add(new SelFnSeasonalAdjusted());
        b.add(new SelFnDropIf());
        b.add(new SelFnTakeIf());
        b.add(new SelFnFilterByTime());
        b.add(new SelFnTimeInterval());
        b.add(new SelFnGetTimestamps());
        b.add(new SelFnBinomialDistribution());
        b.add(new SelFnLinearTrend());
        b.add(new SelFnLogarithmicTrend());
        b.add(new SelFnExponentialTrend());
        b.add(new SelFnKronosMean());
        b.add(new SelFnKronosVariance());
        b.add(new SelFnKronosAdjusted());
        b.add(new SelFnCrop());
        b.add(new SelFnGroupByLabels());
        b.add(new SelFnMap());
        b.add(new SelFnFlatten());
        b.add(new SelFnAsVector());
        b.add(new SelFnEvalTimeInterval());
        b.add(new SelFnDropEmptyLines());
        b.add(new SelFnToVector());
        b.add(new SelFnConstantLine());
        b.add(new SelFnSize());
        b.add(new SelFnInf());
        b.add(new SelFnFallback());

        // Histograms
        b.add(new SelFnHistogramPercentile());
        b.add(new SelFnHistogramSum());
        b.add(new SelFnHistogramAvg());
        b.add(new SelFnHistogramCumulativeDistribution());

        // Summary
        b.add(new SelFnSummaryExtract());

        // Window
        b.add(new SelFnShift());
        b.add(new SelFnMovingAvg());
        b.add(new SelFnMovingSum());
        b.add(new SelFnMovingPercentile());
        b.add(new SelFnAlias());

        // String
        b.add(new SelFnToString());
        b.add(new SelFnToFixed());
        b.add(new SelFnGetLabel());

        // Alerting
        b.add(new SelFnStatusIf());
        b.add(new SelFnAlertEvaluationHistory());

        // Deprecated
        b.add(new SelFnLoad());
        b.add(new SelFnLoad1());
        b.add(new SelFnTransform());

        // Aggregations
        for (var fn : AggrSelFn.Type.values()) {
            b.add(fn.getFunc());
        }
        b.add(new SelFnPercentile());

        // yasm grid related
        b.add(new SelFnGridStep());
        b.add(new SelFnDeltaToRate());
        b.add(new SelFnRateToDelta());

        REGISTRY = b;
    }

    public static SelExprFuncCall exprCall(SelVersion version, AstCall call, List<SelExpr> args) {
        AstIdent name = call.getFunc();
        var types = args.stream().map(SelExpr::type).collect(Collectors.toList());
        var fn = REGISTRY.get(version, name, types);
        var metrics = ExpressionMetrics.I.getFnMetrics(version, fn);
        metrics.parse.inc();
        return new SelExprFuncCall(call, fn, args, metrics);
    }
}
