package ru.yandex.solomon.expression.expr;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.solomon.expression.ExpressionMetrics;
import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.ast.AstOp;
import ru.yandex.solomon.expression.exceptions.InternalCompilerException;
import ru.yandex.solomon.expression.expr.func.SelOpRegistry;
import ru.yandex.solomon.expression.expr.op.bin.SelOpArithDouble;
import ru.yandex.solomon.expression.expr.op.bin.SelOpArithGraph;
import ru.yandex.solomon.expression.expr.op.bin.SelOpArithVectorDouble;
import ru.yandex.solomon.expression.expr.op.bin.SelOpArithVectorGraph;
import ru.yandex.solomon.expression.expr.op.bin.SelOpBinAnd;
import ru.yandex.solomon.expression.expr.op.bin.SelOpBinOr;
import ru.yandex.solomon.expression.expr.op.bin.SelOpCompareDouble;
import ru.yandex.solomon.expression.expr.op.bin.SelOpCompareString;
import ru.yandex.solomon.expression.expr.op.bin.SelOpConcat;
import ru.yandex.solomon.expression.expr.op.un.ArithUnOpMinus;
import ru.yandex.solomon.expression.expr.op.un.ArithUnOpPlus;
import ru.yandex.solomon.expression.expr.op.un.SelOpNot;
import ru.yandex.solomon.expression.version.SelVersion;

/**
 * @author Vladimir Gordiychuk
 */
public class SelOperators {
    public static final SelOpRegistry REGISTRY;

    static {
        SelOpRegistry b = new SelOpRegistry();

        try {

            // unary operators
            b.add(new SelOpNot());
            b.add(new ArithUnOpPlus());
            b.add(new ArithUnOpMinus());

            // Binary
            b.add(new SelOpConcat());
            b.add(new SelOpArithDouble());
            b.add(new SelOpArithVectorDouble());
            b.add(new SelOpArithGraph());
            b.add(new SelOpArithVectorGraph());
            b.add(new SelOpBinAnd());
            b.add(new SelOpBinOr());
            b.add(new SelOpCompareDouble());
            b.add(new SelOpCompareString());

        } catch (InternalCompilerException e) {
            throw new RuntimeException(e);
        }

        REGISTRY = b;
    }

    public static SelExprOpCall exprCall(SelVersion version, Ast astOperation, AstOp astOp, List<SelExpr> args) {
        var types = args.stream().map(SelExpr::type).collect(Collectors.toList());
        var op = REGISTRY.get(version, astOp, types);
        var metrics = ExpressionMetrics.I.getOpMetrics(version, op);
        return new SelExprOpCall(astOperation, op, args, metrics);
    }
}
