package ru.yandex.solomon.expression.expr;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.analytics.GraphDataLoadRequest;
import ru.yandex.solomon.expression.compile.SelStatement;
import ru.yandex.solomon.expression.type.SelTypes;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelectorTypeVisitor {
    private SelectorTypeVisitor() {
    }

    public static List<SelStatement> fillSelectorType(
            Map<SelExprParam, GraphDataLoadRequest.Builder> extVarToRequest,
            List<SelStatement> block)
    {
        return SelExprFnExternalizeVisitor.replaceFnCall(
                SelectorTypeVisitor::isSingleFn,
                fnCall -> markRequestAsSingle(extVarToRequest, fnCall),
                block
        );
    }

    private static boolean isSingleFn(SelExprFuncCall fnCall) {
        return "single".equals(fnCall.getFunc().getName());
    }

    private static SelExpr markRequestAsSingle(
            Map<SelExprParam, GraphDataLoadRequest.Builder> extVarToRequest,
            SelExprFuncCall fnCall)
    {
        SelExpr dataParam = fnCall.getArgs().get(0);
        if (!(dataParam instanceof SelExprParam)) {
            return fnCall;
        }

        GraphDataLoadRequest.Builder builder = extVarToRequest.get(dataParam);
        if (builder == null) {
            return fnCall;
        }

        builder.setType(SelTypes.GRAPH_DATA);
        extVarToRequest.remove(dataParam);

        SelExprParam param = (SelExprParam) dataParam;
        param = new SelExprParam(param.getSourceAst(), SelTypes.GRAPH_DATA);
        extVarToRequest.put(param, builder);

        return param;
    }
}
