package ru.yandex.solomon.expression.expr;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.value.SelValueSideEffect;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface SideEffectProcessor {

    void process(SelValueSideEffect sideEffect);

    static SideEffectProcessor skipping() {
        return (sideEffect) -> {};
    }

    static SideEffectProcessor throwing() {
        return (sideEffect) -> {
            throw new IllegalStateException("Cannot process " + sideEffect + " since no side effect processor was defined");
        };
    }
}
