package ru.yandex.solomon.expression.expr.func;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueGraphData;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.math.GraphDataIntegrate;
import ru.yandex.solomon.model.timeseries.GraphData;

import static ru.yandex.solomon.expression.expr.func.SelFuncArgument.arg;

/**
 * @author rorewillo
 */
@ParametersAreNonnullByDefault
public class GraphDataSelFnIntegrate implements SelFuncProvider {
    public static final List<String> NAMES = List.of("integrate_fn", "integral");

    public static NamedGraphData calculate(NamedGraphData namedGraphData) {
        GraphData result = GraphDataIntegrate.rightRectangleIntegrate(namedGraphData.getGraphData());
        return namedGraphData.toBuilder()
            .setType(MetricType.DGAUGE)
            .setGraphData(result)
            .build();
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        for (String name : NAMES) {
            provide(name, registry);
        }
    }

    public void provide(String name, SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name(name)
            .help("The integral of the metric")
            .category(name.equals("integral_fn") ? SelFuncCategory.DEPRECATED : SelFuncCategory.TRANSFORMATION)
            .args(arg("source").type(SelTypes.GRAPH_DATA))
            .returnType(SelTypes.GRAPH_DATA)
            .handler(args -> {
                var source = args.get(0).castToGraphData().getNamedGraphData();
                return new SelValueGraphData(calculate(source));
            })
            .build());

        registry.add(SelFunc.newBuilder()
            .name(name)
            .help("The integral of the metric")
            .category(SelFuncCategory.TRANSFORMATION)
            .args(SelTypes.GRAPH_DATA_VECTOR)
            .returnType(SelTypes.GRAPH_DATA_VECTOR)
            .handler(args -> {
                var source = args.get(0).castToVector().valueArray();

                var result = new SelValue[source.length];
                for (int index = 0; index < source.length; index++) {
                    var item = source[index].castToGraphData().getNamedGraphData();
                    result[index] = new SelValueGraphData(calculate(item));
                }

                return new SelValueVector(SelTypes.GRAPH_DATA, result);
            })
            .build());
    }
}
