package ru.yandex.solomon.expression.expr.func;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;
import ru.yandex.solomon.expression.NamedGraphData;


/**
 * @author Vladimir Gordiychuk
 */
public class LabelsUtil {
    private LabelsUtil() {
    }

    public static Labels getCommonLabels(List<NamedGraphData> linesMaybeWithoutLabels) {
        List<NamedGraphData> lines = linesMaybeWithoutLabels.stream()
                .filter(ngd -> !ngd.getLabels().isEmpty() || !ngd.getMetricName().isEmpty())
                .collect(Collectors.toList());

        if (lines.isEmpty()) {
            return Labels.empty();
        }

        if (lines.size() == 1) {
            return lines.get(0).getLabels();
        }

        LabelsBuilder commonLabels = lines.get(0).getLabels().toBuilder();

        for (NamedGraphData line : lines) {
            Labels labels = line.getLabels();
            dropNonEqualCommonLabels(commonLabels, labels);
            dropUnusedCommonLabels(commonLabels, labels);
            if (commonLabels.isEmpty()) {
                return commonLabels.build();
            }
        }

        return commonLabels.build();
    }

    private static void dropNonEqualCommonLabels(LabelsBuilder commonLabels, Labels labels) {
        labels.forEach(label -> {
            int commonLabelIdx = commonLabels.indexOf(label.getKey());
            if (commonLabelIdx >= 0) {
                Label commonLabel = commonLabels.at(commonLabelIdx);
                if (!label.equals(commonLabel)) {
                    commonLabels.remove(label.getKey());
                }
            }
        });
    }

    private static void dropUnusedCommonLabels(LabelsBuilder commonLabels, Labels labels) {
        for (int commonLabelIdx = 0; commonLabelIdx < commonLabels.size();) {
            Label commonLabel = commonLabels.at(commonLabelIdx);
            if (!labels.hasSameKey(commonLabel)) {
                commonLabels.remove(commonLabel);
            } else {
                ++commonLabelIdx;
            }
        }
    }
}
