package ru.yandex.solomon.expression.expr.func;

import javax.annotation.ParametersAreNonnullByDefault;

import io.netty.util.internal.ThreadLocalRandom;

import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValueDouble;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelFn0Random01 implements SelFuncProvider {
    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name("random01")
            .category(SelFuncCategory.OTHER)
            .returnType(SelTypes.DOUBLE)
            .handler(args -> new SelValueDouble(ThreadLocalRandom.current().nextDouble()))
            .pure(false)
            .build());
    }
}
