package ru.yandex.solomon.expression.expr.func;

import java.util.Arrays;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueGraphData;
import ru.yandex.solomon.expression.value.SelValueVector;

/**
 * <p>Drop series if there is no not NaN points here</p>
 * <p>Example:
 * <pre>drop_no_data_lines({...})</pre>
 * </p>
 *
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class SelFnDropEmptyLines implements SelFuncProvider {
    @Override
    public void provide(SelFuncRegistry registry) {
        provide("drop_empty_lines", registry, SelFuncCategory.DEPRECATED);
        provide("drop_empty_series", registry, SelFuncCategory.OTHER);
    }

    public void provide(String name, SelFuncRegistry registry, SelFuncCategory category) {
        registry.add(SelFunc.newBuilder()
            .name(name)
            .args(SelTypes.GRAPH_DATA_VECTOR)
            .returnType(SelTypes.GRAPH_DATA_VECTOR)
            .help("Drop series if there is no not NaN points here")
            .category(category)
            .handler(args -> {
                SelValue[] result = Arrays.stream(args.get(0).castToVector().valueArray())
                    .map(item -> item.castToGraphData().getNamedGraphData())
                    .filter(ngd -> !ngd.getGraphData().filterNonNan().isEmpty())
                    .map(SelValueGraphData::new)
                    .toArray(SelValueGraphData[]::new);

                return new SelValueVector(SelTypes.GRAPH_DATA, result);
            })
            .build());
        registry.add(SelFunc.newBuilder()
            .name(name)
            .args(SelTypes.GRAPH_DATA)
            .returnType(SelTypes.GRAPH_DATA_VECTOR)
            .help("Drop series if there is no not NaN points here")
            .category(category)
            .handler(args -> {
                SelValueGraphData selValue = args.get(0).castToGraphData();
                NamedGraphData graphData = selValue.getNamedGraphData();
                boolean isEmpty = graphData.getGraphData().filterNonNan().isEmpty();
                if (isEmpty) {
                    return new SelValueVector(SelTypes.GRAPH_DATA, new SelValue[0]);
                }
                return new SelValueVector(SelTypes.GRAPH_DATA, new SelValue[]{selValue});
            })
            .build());
    }
}
