package ru.yandex.solomon.expression.expr.func;

import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.EvalContext;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.ArgsList;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueDouble;

/**
 * Returns grid step size if available from the request downsampling parameters, or 0 otherwise.
 * Example: <code>let normal = grid_step();</code>
 *
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelFnGridStep implements SelFuncProvider {

    public static final String NAME = "grid_step";
    private static final double MILLIS_IN_SECS = TimeUnit.SECONDS.toMillis(1);

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
                .name(NAME)
                .help("Grid step size in seconds if available from the request downsampling parameters, or 0 otherwise.")
                .category(SelFuncCategory.OTHER)
                .pure(false)
                .returnType(SelTypes.DOUBLE)
                .handler(SelFnGridStep::handler)
                .build());
    }

    private static SelValue handler(EvalContext ctx, ArgsList argsList) {
        return new SelValueDouble(ctx.getGridMillis() / MILLIS_IN_SECS);
    }

}
