package ru.yandex.solomon.expression.expr.func;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.exceptions.EvaluationException;
import ru.yandex.solomon.expression.type.SelTypes;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelFnLoad implements SelFuncProvider {
    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name("load")
            .help("Deprecated")
            .category(SelFuncCategory.DEPRECATED)
            .args(SelTypes.STRING)
            .returnType(SelTypes.GRAPH_DATA_VECTOR)
            .pure(false)
            .handler(args -> {
                throw new EvaluationException(args.getCallRange(), "fn load() must not be invoked in runtime");
            })
            .build());
    }
}
