package ru.yandex.solomon.expression.expr.func;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.expr.EvalContext;
import ru.yandex.solomon.expression.expr.EvalContextImpl;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypeLambda;
import ru.yandex.solomon.expression.type.SelTypeVector;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.ArgsList;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueLambda;
import ru.yandex.solomon.expression.value.SelValueVectorBuilder;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelFnMap implements SelFuncProvider {
    private static SelValue calculate(EvalContext ctx, SelType returnType, ArgsList args) {
        SelValueLambda lambda = args.get(1).castToLambda();
        PositionRange lambdaRange = args.getRange(1);

        var vector = args.get(0).castToVector();
        var result = new SelValueVectorBuilder(returnType);
        for (int index = 0; index < vector.length(); index++) {
            var item = vector.item(index);
            var context = new EvalContextImpl(Map.of(lambda.singleParamName(lambdaRange), item), ctx.getVersion());
            var mapped = lambda.body.eval(context);
            result.add(mapped);
        }

        return result.build();
    }

    private SelFunc function(SelTypeVector vector, SelType result) {
        return SelFunc.newBuilder()
            .name("map")
            .category(SelFuncCategory.TRANSFORMATION)
            .args(vector, new SelTypeLambda(List.of(vector.elementType), result))
            .help("Apply lambda function for each vector item")
            .handler((ctx, args) -> calculate(ctx, result, args))
            .returnType(new SelTypeVector(result))
            .build();
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(function(SelTypes.GRAPH_DATA_VECTOR, SelTypes.GRAPH_DATA));
        for (var vector : SelTypes.ALL_VECTORS) {
            registry.add(function(vector, SelTypes.DOUBLE));
            registry.add(function(vector, SelTypes.BOOLEAN));
            registry.add(function(vector, SelTypes.STRING));
        }
    }
}
