package ru.yandex.solomon.expression.expr.func;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValues;

import static ru.yandex.solomon.expression.expr.func.SelFuncArgument.arg;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelFnMod implements SelFuncProvider {
    private static final String NAME = "mod";
    private static final String HELP = "remainder of integer division";

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
                .name(NAME)
                .help(HELP)
                .category(SelFuncCategory.TRANSFORMATION)
                .args(arg("source").type(SelTypes.DOUBLE), arg("divisor").type(SelTypes.DOUBLE))
                .returnType(SelTypes.DOUBLE)
                .handler(args -> {
                    double divisor = args.get(1).castToScalar().getValue();
                    return SelValues.mapAsDouble(args.get(0).castToScalar(), x -> x % divisor);
                })
                .build());

        registry.add(SelFunc.newBuilder()
                .name(NAME)
                .help(HELP)
                .category(SelFuncCategory.TRANSFORMATION)
                .args(arg("source").type(SelTypes.DOUBLE_VECTOR), arg("divisor").type(SelTypes.DOUBLE))
                .returnType(SelTypes.DOUBLE_VECTOR)
                .handler(args -> {
                    double divisor = args.get(1).castToScalar().getValue();
                    return SelValues.mapArrayAsDouble(args.get(0).castToVector(), x -> x % divisor);
                })
                .build());

        registry.add(SelFunc.newBuilder()
                .name(NAME)
                .help(HELP)
                .category(SelFuncCategory.TRANSFORMATION)
                .args(arg("source").type(SelTypes.GRAPH_DATA).help("applies on each point value"),
                        arg("divisor").type(SelTypes.DOUBLE))
                .returnType(SelTypes.GRAPH_DATA)
                .handler(args -> {
                    double divisor = args.get(1).castToScalar().getValue();
                    return SelValues.mapValueAsDouble(args.get(0).castToGraphData(), x -> x % divisor);
                })
                .build());

        registry.add(SelFunc.newBuilder()
                .name(NAME)
                .help(HELP)
                .category(SelFuncCategory.TRANSFORMATION)
                .args(arg("source").type(SelTypes.GRAPH_DATA_VECTOR).help("applied on each point value"),
                        arg("divisor").type(SelTypes.DOUBLE))
                .returnType(SelTypes.GRAPH_DATA_VECTOR)
                .handler(args -> {
                    double divisor = args.get(1).castToScalar().getValue();
                    return SelValues.mapValuesAsDouble(args.get(0).castToVector(), x -> x % divisor);
                })
                .build());
    }
}
