package ru.yandex.solomon.expression.expr.func;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueGraphData;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.model.timeseries.GraphData;

/**
 * @author Vladimir Gordiychuk
 */
public class SelFnNonNegativeDerivative implements SelFuncProvider {
    public static final String NAME = "non_negative_derivative";

    private NamedGraphData calculate(NamedGraphData namedGraphData) {
        GraphData source = namedGraphData.getGraphData();
        GraphData result = source.deriv();
        return namedGraphData.toBuilder()
            .setType(MetricType.DGAUGE)
            .setGraphData(result)
            .build();
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name(NAME)
            .help("Graph the derivative (dt/diff) of the metric without negative value")
            .category(SelFuncCategory.TRANSFORMATION)
            .args(SelTypes.GRAPH_DATA)
            .returnType(SelTypes.GRAPH_DATA)
            .handler(args -> {
                var source = args.get(0).castToGraphData().getNamedGraphData();
                return new SelValueGraphData(calculate(source));
            })
            .build());

        registry.add(SelFunc.newBuilder()
            .name(NAME)
            .help("Graph the derivative (dt/diff) of the metric without negative value")
            .category(SelFuncCategory.TRANSFORMATION)
            .args(SelTypes.GRAPH_DATA_VECTOR)
            .returnType(SelTypes.GRAPH_DATA_VECTOR)
            .handler(args -> {
                var source = args.get(0).castToVector().valueArray();

                var result = new SelValue[source.length];
                for (int index = 0; index < source.length; index++) {
                    var item = source[index].castToGraphData().getNamedGraphData();
                    result[index] = new SelValueGraphData(calculate(item));
                }

                return new SelValueVector(SelTypes.GRAPH_DATA, result);
            })
            .build());
    }
}
