package ru.yandex.solomon.expression.expr.func;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueGraphData;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.model.timeseries.GraphData;

import static ru.yandex.solomon.expression.expr.func.SelFuncArgument.arg;

/**
 * @author Alexey Trushkin
 */
public class SelFnRateToDelta implements SelFuncProvider {
    public static final String NAME = "rate_to_delta";

    private static NamedGraphData calculate(NamedGraphData namedGraphData) {
        GraphData result = namedGraphData.getGraphData().rateToDelta();
        return namedGraphData.toBuilder()
                .setType(MetricType.DGAUGE)
                .setGraphData(result)
                .build();
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
                .name(NAME)
                .help("Converts rate to delta")
                .category(SelFuncCategory.TRANSFORMATION)
                .args( arg("source").type(SelTypes.GRAPH_DATA))
                .returnType(SelTypes.GRAPH_DATA)
                .handler(args -> {
                    var source = args.get(0).castToGraphData().getNamedGraphData();
                    return new SelValueGraphData(calculate(source));
                })
                .build());

        registry.add(SelFunc.newBuilder()
                .name(NAME)
                .help("Converts rate to delta")
                .category(SelFuncCategory.TRANSFORMATION)
                .args( arg("source").type(SelTypes.GRAPH_DATA_VECTOR))
                .returnType(SelTypes.GRAPH_DATA_VECTOR)
                .handler(args -> {
                    var source = args.get(0).castToVector().valueArray();

                    var result = new SelValue[source.length];
                    for (int index = 0; index < source.length; index++) {
                        var item = source[index].castToGraphData().getNamedGraphData();
                        result[index] = new SelValueGraphData(calculate(item));
                    }

                    return new SelValueVector(SelTypes.GRAPH_DATA, result);
                })
                .build());
    }
}
