package ru.yandex.solomon.expression.expr.func;

import java.util.List;

import ru.yandex.solomon.expression.type.SelType;

import static java.util.Objects.requireNonNull;

/**
 * @author Vladimir Gordiychuk
 */
public class SelFuncArgument {
    private final String name;
    private final SelType type;
    private final String help;
    private final List<String> availableValues;

    private SelFuncArgument(Builder builder) {
        this.name = requireNonNull(builder.name, "name");
        this.type = requireNonNull(builder.type, "type");
        this.help = requireNonNull(builder.help, "help");
        this.availableValues = builder.availableValues;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder arg(String name) {
        return new Builder().name(name);
    }

    public String getName() {
        return name;
    }

    public SelType getType() {
        return type;
    }

    public String getHelp() {
        return help;
    }

    public List<String> getAvailableValues() {
        return availableValues;
    }


    public static class Builder {
        private String name;
        private SelType type;
        private String help = "";
        private List<String> availableValues = List.of();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = requireNonNull(name);
            return this;
        }

        public Builder type(SelType type) {
            this.type = requireNonNull(type);
            return this;
        }

        public Builder help(String help) {
            this.help = requireNonNull(help);
            return this;
        }

        public Builder availableValues(String... values) {
            this.availableValues = List.of(values);
            return this;
        }

        public SelFuncArgument build() {
            return new SelFuncArgument(this);
        }
    }
}
