package ru.yandex.solomon.expression.expr.func.aggr;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.AggrSelFn;
import ru.yandex.solomon.math.doubles.DoubleAggregateFunctions;
import ru.yandex.solomon.model.timeseries.view.DoubleTimeSeriesView;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AggrSelFnAvg extends AggrSelFn {

    @Nonnull
    @Override
    public String name() {
        return "avg";
    }

    @Override
    public double evalArrayView(DoubleArrayView param) {
        return DoubleAggregateFunctions.average(param);
    }

    @Override
    public double evalTimeSeries(DoubleTimeSeriesView timeSeriesView) {
        return DoubleAggregateFunctions.weightedAverage(timeSeriesView);
    }
}
