package ru.yandex.solomon.expression.expr.func.aggr;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.AggrSelFn;
import ru.yandex.solomon.math.doubles.DoubleAggregateFunctions;
import ru.yandex.solomon.model.timeseries.view.DoubleTimeSeriesView;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AggrSelFnIntegrate extends AggrSelFn {

    @Override
    public double evalArrayView(DoubleArrayView param) {
        throw new IllegalArgumentException(name() + " is not applicable to arrays");
    }

    @Override
    public double evalTimeSeries(DoubleTimeSeriesView timeSeriesView) {
        return DoubleAggregateFunctions.integrate(timeSeriesView);
    }

    @Nonnull
    @Override
    public String name() {
        return "integrate";
    }

}
