package ru.yandex.solomon.expression.expr.func.aggr;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.AggrSelFn;
import ru.yandex.solomon.math.doubles.DoubleAggregateFunctions;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;

@ParametersAreNonnullByDefault
public class AggrSelFnInterquartileRange extends AggrSelFn {
    @Override
    public double evalArrayView(DoubleArrayView param) {
        return DoubleAggregateFunctions.interquartileRange(param);
    }

    @Nonnull
    @Override
    public String name() {
        return "iqr";
    }
}
