package ru.yandex.solomon.expression.expr.func.aggr;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.AggrSelFn;
import ru.yandex.solomon.math.doubles.DoubleAggregateFunctions;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AggrSelFnLast extends AggrSelFn {

    @Override
    public double evalArrayView(DoubleArrayView param) {
        return DoubleAggregateFunctions.lastSkipNan(param);
    }

    @Nonnull
    @Override
    public String name() {
        return "last";
    }
}
