package ru.yandex.solomon.expression.expr.func.aggr;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.AggrSelFn;
import ru.yandex.solomon.math.doubles.DoubleAggregateFunctions;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AggrSelFnMax extends AggrSelFn {

    @Nonnull
    @Override
    public String name() {
        return "max";
    }

    @Override
    public double evalArrayView(DoubleArrayView param) {
        return DoubleAggregateFunctions.max(param);
    }
}
