package ru.yandex.solomon.expression.expr.func.aggr;

import java.util.concurrent.ThreadLocalRandom;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.AggrSelFn;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class AggrSelFnRandom extends AggrSelFn {
    @Nonnull
    @Override
    public String name() {
        return "random";
    }

    @Override
    public boolean isPure() {
        return false;
    }

    @Override
    public double evalArrayView(DoubleArrayView param) {
        if (param.length() == 0) {
            throw new IllegalArgumentException("array must be not empty in random()");
        }
        var index = ThreadLocalRandom.current().nextInt(param.from, param.to);
        return param.at(index);
    }
}
