package ru.yandex.solomon.expression.expr.func.analytical;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueBoolean;
import ru.yandex.solomon.expression.value.SelValueVector;


/**
 * Reduce vector of boolean into single boolean by OR condition
 * <p>
 * Example:
 * <pre>any_of(map(load('sensor=cpuUseTime&host=*'), |sensor| max(sensor) > 10)) -> bool;</pre>
 *
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelFnAnyOf implements SelFuncProvider {
    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name("any_of")
            .help("Reduce vector of boolean into single boolean by OR condition")
            .category(SelFuncCategory.OTHER)
            .args(SelTypes.BOOLEAN_VECTOR)
            .returnType(SelTypes.BOOLEAN)
            .handler(args -> {
                SelValueVector items = args.get(0).castToVector();
                for (SelValue bool : items.valueArray()) {
                    if (bool.castToBoolean().getValue()) {
                        return SelValueBoolean.TRUE;
                    }
                }

                return SelValueBoolean.FALSE;
            })
            .build());
    }
}
