package ru.yandex.solomon.expression.expr.func.analytical;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.math3.distribution.BinomialDistribution;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValueDouble;

import static ru.yandex.solomon.expression.expr.func.SelFuncArgument.arg;

/**
 * Example usage:
 * <pre>{@code
 *   let result = binomial_distribution(100, 0.2, 20);
 * }</pre>
 *
 * @author Vladimir Gordiychuk
 * @see <a href="https://en.wikipedia.org/wiki/Binomial_distribution">Binomial_distribution</a>
 */
@ParametersAreNonnullByDefault
public class SelFnBinomialDistribution implements SelFuncProvider {
    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name("binomial_distribution")
            .help("<a href=\"https://en.wikipedia.org/wiki/Binomial_distribution\">Binomial_distribution</a>")
            .category(SelFuncCategory.OTHER)
            .args(
                arg("tirals").type(SelTypes.DOUBLE),
                arg("probability").type(SelTypes.DOUBLE),
                arg("success").type(SelTypes.DOUBLE))
            .returnType(SelTypes.DOUBLE)
            .handler(args -> {
                int trials = Math.toIntExact((long) args.get(0).castToScalar().getValue());
                double probability = args.get(1).castToScalar().getValue();
                int success = Math.toIntExact((long) args.get(2).castToScalar().getValue());
                double result = new BinomialDistribution(trials, probability).probability(success);
                return new SelValueDouble(result);
            })
            .build());
    }
}
