package ru.yandex.solomon.expression.expr.func.analytical;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueGraphData;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.math.Crop;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayListOrView;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelFnCrop implements SelFuncProvider {
    public static final String NAME = "crop";

    private static NamedGraphData cropGraphData(NamedGraphData namedGraphData, Interval interval) {
        AggrGraphDataArrayListOrView result = Crop.crop(namedGraphData.getAggrGraphDataArrayList(), interval);
        return namedGraphData.toBuilder()
            .setGraphData(result)
            .build();
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name(NAME)
            .help("Crop data by specified interval")
            .category(SelFuncCategory.INTERNAL)
            .args(SelTypes.GRAPH_DATA, SelTypes.INTERVAL)
            .returnType(SelTypes.GRAPH_DATA)
            .handler(args -> {
                var source = args.get(0).castToGraphData().getNamedGraphData();
                var interval = args.get(1).castToInterval().getInterval();
                return new SelValueGraphData(cropGraphData(source, interval));
            })
            .build());

        registry.add(SelFunc.newBuilder()
            .name(NAME)
            .help("Crop data by specified interval")
            .category(SelFuncCategory.OTHER)
            .args(SelTypes.GRAPH_DATA_VECTOR, SelTypes.INTERVAL)
            .returnType(SelTypes.GRAPH_DATA_VECTOR)
            .handler(args -> {
                var source = args.get(0).castToVector().valueArray();
                var interval = args.get(1).castToInterval().getInterval();

                var result = new SelValue[source.length];
                for (int index = 0; index < source.length; index++) {
                    var item = source[index].castToGraphData().getNamedGraphData();
                    result[index] = new SelValueGraphData(cropGraphData(item, interval));
                }

                return new SelValueVector(SelTypes.GRAPH_DATA, result);
            })
            .build());
    }
}
