package ru.yandex.solomon.expression.expr.func.analytical;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueGraphData;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.model.point.RecyclableAggrPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;

import static ru.yandex.solomon.expression.expr.func.SelFuncArgument.arg;

/**
 * Example usage {@code drop_nan(group_by_time(15s, 'max', load('host=*')))}
 *
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelFnDropNan implements SelFuncProvider {
    private static NamedGraphData calculate(NamedGraphData named) {
        var source = named.getAggrGraphDataArrayList();
        if (source.isEmpty()) {
            return named;
        }

        var result = new AggrGraphDataArrayList(source.columnSetMask(), source.length());
        var point = RecyclableAggrPoint.newInstance();
        try {
            var it = source.iterator();
            while (it.next(point)) {
                if (Double.isNaN(point.getValueDivided())) {
                    continue;
                }
                result.addRecord(point);
            }
        } finally {
            point.recycle();
        }
        return named.toBuilder()
            .setGraphData(result)
            .build();
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name("drop_nan")
            .help("Drop points where value is NaN")
            .category(SelFuncCategory.TRANSFORMATION)
            .args(arg("source").type(SelTypes.GRAPH_DATA))
            .returnType(SelTypes.GRAPH_DATA)
            .handler(args -> {
                var source = args.get(0).castToGraphData().getNamedGraphData();
                return new SelValueGraphData(calculate(source));
            })
            .build());

        registry.add(SelFunc.newBuilder()
            .name("drop_nan")
            .help("Drop points where value is NaN")
            .category(SelFuncCategory.TRANSFORMATION)
            .args(arg("source").type(SelTypes.GRAPH_DATA_VECTOR))
            .returnType(SelTypes.GRAPH_DATA_VECTOR)
            .handler(args -> {
                var source = args.get(0).castToVector().valueArray();

                var result = new SelValue[source.length];
                for (int index = 0; index < source.length; index++) {
                    var item = source[index].castToGraphData().getNamedGraphData();
                    result[index] = new SelValueGraphData(calculate(item));
                }

                return new SelValueVector(SelTypes.GRAPH_DATA, result);
            })
            .build());
    }
}
