package ru.yandex.solomon.expression.expr.func.analytical;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.expression.value.SelValueWithRange;
import ru.yandex.solomon.expression.value.SelValues;
import ru.yandex.solomon.math.GraphDataMath;
import ru.yandex.solomon.model.timeseries.GraphData;

/**
 * Get timestamps data from a series as a Timeseries (in seconds)
 * Example usage:
 * <pre>{@code
 *   let source = myMetric{host=cluster};
 *   let timestamps = get_timestamps(source);
 * }</pre>
 *
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelFnGetTimestamps implements SelFuncProvider {

    private static SelValue extract(SelValueWithRange source) {
        GraphData single = SelValues.getSingleGraphData(source).getGraphData();
        return new SelValueVector(GraphDataMath.getTimestampsAsEpochSeconds(single).copyOrArray());
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name("get_timestamps")
            .category(SelFuncCategory.OTHER)
            .help("Get timestamps data from a series as a Timeseries (in seconds)")
            .args(SelTypes.GRAPH_DATA)
            .returnType(SelTypes.DOUBLE_VECTOR)
            .handler(args -> {
                var source = args.getWithRange(0);
                return extract(source);
            })
            .build());

        registry.add(SelFunc.newBuilder()
            .name("get_timestamps")
            .category(SelFuncCategory.OTHER)
            .help("Get timestamps data from a series as a Timeseries (in seconds)")
            .args(SelTypes.GRAPH_DATA_VECTOR)
            .returnType(SelTypes.DOUBLE_VECTOR)
            .handler(args -> {
                var source = args.getWithRange(0);
                return extract(source);
            })
            .build());
    }
}
