package ru.yandex.solomon.expression.expr.func.analytical;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValues;

/**
 * Function that extract single Timeseries from a Vector of Timeseries with one element
 * Deprecated <pre>load1</pre> is equivalent to <pre>single({...})</pre> construction
 *
 * Usage example:
 * <pre>
 *     let data = myMetric{host=cluster};
 *     let singleLine = single(data);
 * </pre>
 *
 * When selector is wrapped with single(...) call, type info is propagated to the load request
 * <pre>
 *     let singleLine = single(myMetric{host=cluster}); // generates single line load request, just as load1
 * </pre>
 *
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelFnSingle implements SelFuncProvider {

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name("single")
            .category(SelFuncCategory.OTHER)
            .args(SelTypes.GRAPH_DATA_VECTOR)
            .returnType(SelTypes.GRAPH_DATA)
            .handler(args -> {
                var source = args.getWithRange(0);
                return SelValues.getSingleGraphData(source);
            })
            .build());
    }
}
