package ru.yandex.solomon.expression.expr.func.analytical;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValueDouble;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelFnSize implements SelFuncProvider {
    @Override
    public void provide(SelFuncRegistry registry) {
        for (var type : SelTypes.ALL_VECTORS) {
            registry.add(SelFunc.newBuilder()
                    .name("size")
                    .help("Size of the given vector")
                    .category(SelFuncCategory.OTHER)
                    .args(type)
                    .returnType(SelTypes.DOUBLE)
                    .pure(true)
                    .handler(args -> {
                        var source = args.get(0).castToVector();
                        return new SelValueDouble(source.length());
                    })
                    .build());
        }
    }
}
