package ru.yandex.solomon.expression.expr.func.analytical.histogram;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.stat.LegacyHistogramIterator;
import ru.yandex.solomon.math.stat.VectorPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.iterator.GenericIterator;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class HistogramCumulativeDistributionIteratorFactory extends HistogramIteratorFactory<VectorPoint> {

    private final double[] lowerBounds;
    private final double[] upperBounds;
    private final boolean normalize;

    private HistogramCumulativeDistributionIteratorFactory(
            String funcName,
            boolean groupLegacyHistograms,
            double[] lowerBounds,
            double[] upperBounds,
            boolean normalize)
    {
        super(funcName, groupLegacyHistograms);
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
        this.normalize = normalize;
    }

    public static HistogramCumulativeDistributionIteratorFactory of(
            String funcName,
            boolean groupLegacyHistograms,
            double[] lowerBounds,
            double[] upperBounds,
            boolean normalize)
    {
        return new HistogramCumulativeDistributionIteratorFactory(funcName, groupLegacyHistograms,
                lowerBounds, upperBounds, normalize);
    }

    @Override
    GenericIterator<VectorPoint> forLegacyHistogram(LegacyHistogramIterator iterator) {
        return HistogramCumulativeDistributionIterators.forLegacyHist(iterator, lowerBounds, upperBounds, normalize);
    }

    @Override
    GenericIterator<VectorPoint> forHistogram(AggrGraphDataListIterator iterator) {
        return HistogramCumulativeDistributionIterators.forHist(iterator, lowerBounds, upperBounds, normalize);
    }

    @Override
    GenericIterator<VectorPoint> forLogHistogram(AggrGraphDataListIterator iterator) {
        return HistogramCumulativeDistributionIterators.forLogHist(iterator, lowerBounds, upperBounds, normalize);
    }
}
