package ru.yandex.solomon.expression.expr.func.analytical.histogram;

import java.util.EnumSet;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.stat.HistogramCumulativeDistribution;
import ru.yandex.solomon.math.stat.HistogramCumulativeDistributionIterator;
import ru.yandex.solomon.math.stat.HistogramCumulativeDistributionIterator.Options;
import ru.yandex.solomon.math.stat.LegacyHistogramIterator;
import ru.yandex.solomon.math.stat.LegacyHistogramPoint;
import ru.yandex.solomon.math.stat.VectorPoint;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.iterator.GenericIterator;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class HistogramCumulativeDistributionIterators {
    private static final EnumSet<Options> EMPTY = EnumSet.noneOf(Options.class);

    private static class LegacyHistCumulativeDistributionIterator extends HistogramCumulativeDistributionIterator<LegacyHistogramPoint> {
        private LegacyHistCumulativeDistributionIterator(
                LegacyHistogramIterator iterator,
                double[] lowerBounds,
                double[] upperBounds,
                boolean normalize)
        {
            super(iterator, lowerBounds, upperBounds, normalize ? EnumSet.of(Options.NORMALIZE) : EMPTY);
        }

        @Override
        public LegacyHistogramPoint newPoint() {
            return new LegacyHistogramPoint();
        }

        @Override
        public void computeCumulativeDistribution(LegacyHistogramPoint point, double[] cumulativeCount, double[] sortedBounds) {
            HistogramCumulativeDistribution.cumulativeCount(point, cumulativeCount, sortedBounds);
        }
    }

    static GenericIterator<VectorPoint> forLegacyHist(LegacyHistogramIterator iterator, double[] lowerBounds, double[] upperBounds, boolean normalize) {
        return new LegacyHistCumulativeDistributionIterator(iterator, lowerBounds, upperBounds, normalize);
    }

    private static class HistCumulativeDistributionIterator extends HistogramCumulativeDistributionIterator<AggrPoint> {
        private HistCumulativeDistributionIterator(
                AggrGraphDataListIterator iterator,
                double[] lowerBounds,
                double[] upperBounds,
                boolean normalize)
        {
            super(iterator, lowerBounds, upperBounds, normalize ? EnumSet.of(Options.NORMALIZE) : EMPTY);
        }

        @Override
        public AggrPoint newPoint() {
            return new AggrPoint();
        }

        @Override
        public void computeCumulativeDistribution(AggrPoint point, double[] cumulativeCount, double[] sortedBounds) {
            HistogramCumulativeDistribution.cumulativeCount(point.histogram, cumulativeCount, sortedBounds);
        }
    }

    static GenericIterator<VectorPoint> forHist(
            AggrGraphDataListIterator iterator,
            double[] lowerBounds,
            double[] upperBounds,
            boolean normalize)
    {
        return new HistCumulativeDistributionIterator(iterator, lowerBounds, upperBounds, normalize);
    }

    private static class LogHistCumulativeDistributionIterator extends HistogramCumulativeDistributionIterator<AggrPoint> {
        private static final EnumSet<Options> DEFAULT = EnumSet.of(Options.ZERO_UPPER_BOUND_CORRECTION);
        private static final EnumSet<Options> NORMALIZE = EnumSet.of(Options.ZERO_UPPER_BOUND_CORRECTION, Options.NORMALIZE);

        private LogHistCumulativeDistributionIterator(
                AggrGraphDataListIterator iterator,
                double[] lowerBounds,
                double[] upperBounds,
                boolean normalize)
        {
            super(iterator, lowerBounds, upperBounds, normalize ? NORMALIZE : DEFAULT);
        }

        @Override
        public AggrPoint newPoint() {
            return new AggrPoint();
        }

        @Override
        public void computeCumulativeDistribution(AggrPoint point, double[] cumulativeCount, double[] sortedBounds) {
            HistogramCumulativeDistribution.cumulativeCount(point.logHistogram, cumulativeCount, sortedBounds);
        }
    }

    static GenericIterator<VectorPoint> forLogHist(
            AggrGraphDataListIterator iterator,
            double[] lowerBounds,
            double[] upperBounds,
            boolean normalize)
    {
        return new LogHistCumulativeDistributionIterator(iterator, lowerBounds, upperBounds, normalize);
    }
}
