package ru.yandex.solomon.expression.expr.func.analytical.histogram;

import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.exceptions.EvaluationException;
import ru.yandex.solomon.math.stat.LegacyHistogramIterator;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.iterator.GenericIterator;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
abstract class HistogramIteratorFactory<T> {
    private final String funcName;
    private final boolean groupLegacyHistograms;

    HistogramIteratorFactory(String funcName, boolean groupLegacyHistograms) {
        this.funcName = funcName;
        this.groupLegacyHistograms = groupLegacyHistograms;
    }

    abstract GenericIterator<T> forLegacyHistogram(LegacyHistogramIterator iterator);
    abstract GenericIterator<T> forHistogram(AggrGraphDataListIterator iterator);
    abstract GenericIterator<T> forLogHistogram(AggrGraphDataListIterator iterator);

    Map<Labels, GenericIterator<T>> makeIteratorForDataType(HistogramFunc.HistogramArgument hist) {
        if (hist.source.isEmpty()) {
            return Map.of();
        }

        if (hist.isLegacy()) {
            return hist.getLegacyHistogramBuckets(groupLegacyHistograms).entrySet().stream()
                    .collect(Collectors.toMap(Map.Entry::getKey,
                        e -> forLegacyHistogram(new LegacyHistogramIterator(e.getValue()))));
        }

        return hist.source.stream()
                .collect(Collectors.toMap(NamedGraphData::getLabels, ngd -> {
                    if (ngd.getAggrGraphDataArrayList().isEmpty()) {
                        return forHistogram(ngd.getAggrGraphDataArrayList().iterator());
                    }

                    return switch (ngd.getDataType()) {
                        case HIST, HIST_RATE -> forHistogram(ngd.getAggrGraphDataArrayList().iterator());
                        case LOG_HISTOGRAM -> forLogHistogram(ngd.getAggrGraphDataArrayList().iterator());
                        default -> throw new EvaluationException(hist.linesRange, "Metric type " + ngd.getDataType() +
                                " is not a native histogram type in " + funcName);
                    };
                }));
    }
}
