package ru.yandex.solomon.expression.expr.func.analytical.histogram;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.stat.LegacyHistogramIterator;
import ru.yandex.solomon.math.stat.VectorPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.iterator.GenericIterator;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class HistogramPercentileIteratorFactory extends HistogramIteratorFactory<VectorPoint> {
    private final double[] percLevels;

    HistogramPercentileIteratorFactory(String funcName, boolean groupLegacyHistograms, double[] percLevels) {
        super(funcName, groupLegacyHistograms);
        this.percLevels = percLevels;
    }

    @Override
    GenericIterator<VectorPoint> forLegacyHistogram(LegacyHistogramIterator iterator) {
        return HistogramPercentileIterators.forLegacyHist(iterator, percLevels);
    }

    @Override
    GenericIterator<VectorPoint> forHistogram(AggrGraphDataListIterator iterator) {
        return HistogramPercentileIterators.forHist(iterator, percLevels);
    }

    @Override
    GenericIterator<VectorPoint> forLogHistogram(AggrGraphDataListIterator iterator) {
        return HistogramPercentileIterators.forLogHist(iterator, percLevels);
    }
}
