package ru.yandex.solomon.expression.expr.func.analytical.histogram;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.solomon.math.stat.HistogramPercentile;
import ru.yandex.solomon.math.stat.HistogramPercentileIterator;
import ru.yandex.solomon.math.stat.LegacyHistogramIterator;
import ru.yandex.solomon.math.stat.LegacyHistogramPoint;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.iterator.GenericIterator;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class HistogramPercentileIterators {

    static LegacyHistPercentileIterator forLegacyHist(LegacyHistogramIterator iterator, double[] percentileLevels) {
        return new LegacyHistPercentileIterator(iterator, percentileLevels);
    }

    static HistPercentileIterator forHist(AggrGraphDataListIterator iterator, double[] percentileLevels) {
        return new HistPercentileIterator(iterator, percentileLevels);
    }

    static LogHistPercentileIterator forLogHist(AggrGraphDataListIterator iterator, double[] percentileLevels) {
        return new LogHistPercentileIterator(iterator, percentileLevels);
    }

    private static class LegacyHistPercentileIterator extends HistogramPercentileIterator<LegacyHistogramPoint> {
        private LegacyHistPercentileIterator(GenericIterator<LegacyHistogramPoint> iterator, double[] percentileLevels) {
            super(iterator, percentileLevels);
        }

        @Override
        public LegacyHistogramPoint newPoint() {
            return new LegacyHistogramPoint();
        }

        @Override
        public void computePercentiles(LegacyHistogramPoint point, double[] percentiles, double[] percentileLevels)
        {
            HistogramPercentile.percentiles(point, percentiles, percentileLevels);
        }
    }

    private static class HistPercentileIterator extends HistogramPercentileIterator<AggrPoint> {
        double[] buckets = new double[Histograms.MAX_BUCKETS_COUNT];

        private HistPercentileIterator(AggrGraphDataListIterator iterator, double[] percentileLevels) {
            super(iterator, percentileLevels);
        }

        @Override
        public AggrPoint newPoint() {
            return new AggrPoint();
        }

        @Override
        public void computePercentiles(AggrPoint point, double[] percentiles, double[] percentileLevels) {
            HistogramPercentile.percentiles(point.histogram, buckets, percentiles, percentileLevels);
        }
    }

    private static class LogHistPercentileIterator extends HistogramPercentileIterator<AggrPoint> {
        double[] buckets = new double[LogHistogram.LIMIT_MAX_BUCKETS_SIZE];

        private LogHistPercentileIterator(AggrGraphDataListIterator iterator, double[] percentileLevels) {
            super(iterator, percentileLevels);
        }

        @Override
        public AggrPoint newPoint() {
            return new AggrPoint();
        }

        @Override
        public void computePercentiles(AggrPoint point, double[] percentiles, double[] percentileLevels) {
            HistogramPercentile.percentiles(point.logHistogram, buckets, percentiles, percentileLevels);
        }
    }
}
