package ru.yandex.solomon.expression.expr.func.analytical.histogram;

import java.util.function.ToDoubleFunction;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.stat.HistogramReduceIterator;
import ru.yandex.solomon.math.stat.LegacyHistogramIterator;
import ru.yandex.solomon.math.stat.LegacyHistogramPoint;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.MutableDataPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.solomon.model.timeseries.iterator.GenericIterator;
import ru.yandex.solomon.model.type.Histogram;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class HistogramReduceIteratorFactory extends HistogramIteratorFactory<MutableDataPoint> {
    private final ToDoubleFunction<LegacyHistogramPoint> reduceLegacy;
    private final ToDoubleFunction<Histogram> reduceHist;
    private final ToDoubleFunction<LogHistogram> reduceLogHist;

    private HistogramReduceIteratorFactory(
            String funcName,
            boolean groupLegacyHistograms,
            ToDoubleFunction<LegacyHistogramPoint> reduceLegacy,
            ToDoubleFunction<Histogram> reduceHist,
            ToDoubleFunction<LogHistogram> reduceLogHist)
    {
        super(funcName, groupLegacyHistograms);
        this.reduceLegacy = reduceLegacy;
        this.reduceHist = reduceHist;
        this.reduceLogHist = reduceLogHist;
    }

    public static HistogramReduceIteratorFactory of(
            String funcName,
            boolean groupLegacyHistograms,
            ToDoubleFunction<LegacyHistogramPoint> reduceLegacy,
            ToDoubleFunction<Histogram> reduceHist,
            ToDoubleFunction<LogHistogram> reduceLogHist)
    {
        return new HistogramReduceIteratorFactory(funcName, groupLegacyHistograms, reduceLegacy, reduceHist, reduceLogHist);
    }

    @Override
    GenericIterator<MutableDataPoint> forLegacyHistogram(LegacyHistogramIterator iterator) {
        return HistogramReduceIterator.of(iterator, LegacyHistogramPoint::new, reduceLegacy);
    }

    @Override
    GenericIterator<MutableDataPoint> forHistogram(AggrGraphDataListIterator iterator) {
        return HistogramReduceIterator.of(iterator, AggrPoint::new, point -> reduceHist.applyAsDouble(point.histogram));
    }

    @Override
    GenericIterator<MutableDataPoint> forLogHistogram(AggrGraphDataListIterator iterator) {
        return HistogramReduceIterator.of(iterator, AggrPoint::new, point -> reduceLogHist.applyAsDouble(point.logHistogram));
    }
}
