package ru.yandex.solomon.expression.expr.func.analytical.histogram;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.stat.VectorPoint;
import ru.yandex.solomon.model.point.MutableDataPoint;
import ru.yandex.solomon.model.point.RecyclableAggrPoint;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.solomon.model.timeseries.iterator.GenericIterator;

import static ru.yandex.solomon.model.point.column.StockpileColumns.minColumnSet;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class IteratorHelpers {
    private IteratorHelpers() {}

    static AggrGraphDataArrayList consumeToAggrGraphData(GenericIterator<MutableDataPoint> iterator) {
        int estimatedCapacity = iterator.estimatePointsCount();
        if (estimatedCapacity == -1) {
            estimatedCapacity = 10;
        }

        AggrGraphDataArrayList result = new AggrGraphDataArrayList(minColumnSet(MetricType.DGAUGE), estimatedCapacity);

        MutableDataPoint point = new MutableDataPoint();
        RecyclableAggrPoint aggrPoint = RecyclableAggrPoint.newInstance();
        try {
            aggrPoint.reset(minColumnSet(MetricType.DGAUGE));
            while (iterator.next(point)) {
                aggrPoint.setTsMillis(point.getTsMillis());
                aggrPoint.setValue(point.getValue());
                result.addRecord(aggrPoint);
            }
        } finally {
            aggrPoint.recycle();
        }

        return result;
    }

    static List<AggrGraphDataArrayList> consumeToListAggrGraphData(GenericIterator<VectorPoint> iterator, int size) {
        int estimatedCapacity = iterator.estimatePointsCount();
        if (estimatedCapacity == -1) {
            estimatedCapacity = 10;
        }

        List<AggrGraphDataArrayList> lines = new ArrayList<>(size);
        for (int i = 0; i < size; i++) {
            lines.add(new AggrGraphDataArrayList(minColumnSet(MetricType.DGAUGE), estimatedCapacity));
        }

        VectorPoint point = new VectorPoint(size);
        RecyclableAggrPoint aggrPoint = RecyclableAggrPoint.newInstance();
        try {
            aggrPoint.reset(minColumnSet(MetricType.DGAUGE));
            while (iterator.next(point)) {
                aggrPoint.setTsMillis(point.tsMillis);
                for (int i = 0; i < size; i++) {
                    aggrPoint.setValue(point.values[i]);
                    lines.get(i).addRecord(aggrPoint);
                }
            }
        } finally {
            aggrPoint.recycle();
        }

        return lines;
    }
}
