package ru.yandex.solomon.expression.expr.func.analytical.rank;

import java.util.Comparator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.collection.NanComparator;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public enum RankType {
    TOP(NanComparator.nanFirst(Double::compare).reversed()),
    BOTTOM(NanComparator.nanLast(Double::compare));

    private final Comparator<Double> comparator;

    RankType(Comparator<Double> comparator) {
        this.comparator = comparator;
    }

    public Comparator<Double> getComparator() {
        return comparator;
    }
}
