package ru.yandex.solomon.expression.expr.func.analytical.trends;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.stat.trends.ExpTrendLine;
import ru.yandex.solomon.math.stat.trends.TrendLineUtils;
import ru.yandex.solomon.model.timeseries.GraphData;

/**
 * Compute exponential trend in given interval using source data
 * <p>
 * Example:
 * <pre>exponential_trend(source, 0m, 1d)</pre>
 *
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class SelFnExponentialTrend extends SelFnTrend {
    @Override
    protected String name() {
        return "exponential_trend";
    }

    @Override
    protected String help() {
        return "Compute exponential trend in given interval using source data";
    }

    @Override
    protected GraphData computeTrendLine(GraphData graphData, Duration fromDuration, Duration toDuration) {
        return TrendLineUtils.computeTrendLine(graphData, fromDuration, toDuration, ExpTrendLine::new);
    }
}
