package ru.yandex.solomon.expression.expr.func.analytical.trends;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.stat.trends.LinearTrendLine;
import ru.yandex.solomon.math.stat.trends.TrendLineUtils;
import ru.yandex.solomon.model.timeseries.GraphData;

/**
 * Compute linear trend in given interval using source data
 * <p>
 * Example:
 * <pre>linear_trend(source, 0m, 1d)</pre>
 *
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class SelFnLinearTrend extends SelFnTrend {
    @Override
    protected String name() {
        return "linear_trend";
    }

    @Override
    protected String help() {
        return "Compute linear trend in given interval using source data";
    }

    @Override
    protected GraphData computeTrendLine(GraphData graphData, Duration fromDuration, Duration toDuration) {
        return TrendLineUtils.computeTrendLine(graphData, fromDuration, toDuration, LinearTrendLine::new);
    }
}
