package ru.yandex.solomon.expression.expr.func.string;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValueString;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelFnToString implements SelFuncProvider {
    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name("to_string")
            .help("string represent of value")
            .category(SelFuncCategory.OTHER)
            .args(SelTypes.STRING)
            .returnType(SelTypes.STRING)
            .handler(args -> args.get(0))
            .build());

        registry.add(SelFunc.newBuilder()
            .name("to_string")
            .help("string represent of value")
            .category(SelFuncCategory.OTHER)
            .args(SelTypes.BOOLEAN)
            .returnType(SelTypes.STRING)
            .handler(args -> new SelValueString(String.valueOf(args.get(0).castToBoolean().getValue())))
            .build());

        registry.add(SelFunc.newBuilder()
            .name("to_string")
            .help("string represent of value")
            .category(SelFuncCategory.OTHER)
            .args(SelTypes.DOUBLE)
            .returnType(SelTypes.STRING)
            .handler(args -> new SelValueString(String.valueOf(args.get(0).castToScalar().getValue())))
            .build());
    }
}
