package ru.yandex.solomon.expression.expr.func.util;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueGraphData;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.labels.FormatLabel;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelFnAlias implements SelFuncProvider {
    private NamedGraphData calculate(NamedGraphData namedGraphData, String alias) {
        String formattedAlias = FormatLabel.formatLabel(alias, namedGraphData.getLabels());
        return namedGraphData.toBuilder()
            .setAlias(formattedAlias)
            .build();
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name("alias")
            .help("Add name for metric, for example my.metric.{{key}}")
            .category(SelFuncCategory.OTHER)
            .args(SelTypes.GRAPH_DATA, SelTypes.STRING)
            .returnType(SelTypes.GRAPH_DATA)
            .handler(args -> {
                var source = args.get(0).castToGraphData().getNamedGraphData();
                var alias = args.get(1).castToString().getValue();
                return new SelValueGraphData(calculate(source, alias));
            })
            .build());

        registry.add(SelFunc.newBuilder()
            .name("alias")
            .help("Add name for metric, for example my.metric.{{key}}")
            .category(SelFuncCategory.OTHER)
            .args(SelTypes.GRAPH_DATA_VECTOR, SelTypes.STRING)
            .returnType(SelTypes.GRAPH_DATA_VECTOR)
            .handler(args -> {
                var source = args.get(0).castToVector().valueArray();
                var alias = args.get(1).castToString().getValue();

                var result = new SelValue[source.length];
                for (int index = 0; index < source.length; index++) {
                    var item = source[index].castToGraphData().getNamedGraphData();
                    result[index] = new SelValueGraphData(calculate(item, alias));
                }

                return new SelValueVector(SelTypes.GRAPH_DATA, result);
            })
            .build());
    }
}
