package ru.yandex.solomon.expression.expr.func.util;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypeVector;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.ArgsList;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueVectorBuilder;

/**
 * Group arguments into vector
 * <p>
 * Example usage:
 * {@code as_vector(1, 2, 3)},
 * {@code as_vector(group_lines('sum', {host=a}), group_lines('sum', {host=b}))}
 *
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelFnAsVector implements SelFuncProvider {
    private static SelValue calculate(SelType type, ArgsList args) {
        SelValueVectorBuilder builder = new SelValueVectorBuilder(type);
        args.stream()
            .forEachOrdered(builder::add);
        return builder.build();
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        var types = List.of(
            SelTypes.DOUBLE,
            SelTypes.BOOLEAN,
            SelTypes.STRING,
            SelTypes.DURATION,
            SelTypes.GRAPH_DATA,
            SelTypes.GRAPH_DATA_VECTOR,
            SelTypes.DOUBLE_VECTOR,
            SelTypes.BOOLEAN_VECTOR,
            SelTypes.STRING_VECTOR
        );

        for (var type : types) {
            registry.add(SelFunc.newBuilder()
                .name("as_vector")
                .category(SelFuncCategory.OTHER)
                .help("Wrap argument to vector")
                .args(type)
                .varArg(true)
                .returnType(new SelTypeVector(type))
                .handler(args -> calculate(type, args))
                .build());
        }
    }
}
