package ru.yandex.solomon.expression.expr.func.util;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.ArgsList;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.expression.value.SelValueVectorBuilder;

/**
 * Group multiple vectors into single vector
 *
 * Example usage: {@code flatten(as_vector(1, 2, 3), as_vector(4, 5, 6));}
 *
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelFnFlatten implements SelFuncProvider {

    private static SelValue calculate(SelType type, ArgsList args) {
        SelValueVectorBuilder builder = new SelValueVectorBuilder(type);
        args.stream().forEachOrdered(value -> {
            SelValueVector vector = value.castToVector();
            for (int index = 0; index < vector.length(); index++) {
                builder.add(vector.item(index));
            }
        });
        return builder.build();
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        for (var type : SelTypes.ALL_VECTORS) {
            registry.add(SelFunc.newBuilder()
                .name("flatten")
                .category(SelFuncCategory.OTHER)
                .help("Unwrap vectors into one")
                .varArg(true)
                .args(type)
                .returnType(type)
                .handler(args -> calculate(type.elementType, args))
                .build());
        }
    }
}
