package ru.yandex.solomon.expression.expr.func.util;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValueDouble;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelFnInf implements SelFuncProvider {

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
                .help("Returns positive infinity value. Same as 1 / 0")
                .name("inf")
                .category(SelFuncCategory.OTHER)
                .returnType(SelTypes.DOUBLE)
                .handler(args -> new SelValueDouble(Double.POSITIVE_INFINITY))
                .build());
    }
}
