package ru.yandex.solomon.expression.expr.func.util;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypeVector;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueVector;

/**
 * Convert element or vector of elements to vector of elements.
 * Necessary to convert several elements with different types (Timeseries, Vector<Timeseries>) to flatten vector
 * to flatten vector with strict typification.
 *
 * Example usage:
 * - {@code to_vector(as_vector(1, 2, 3)}
 * - {@code to_vector(1)}
 *
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class SelFnToVector implements SelFuncProvider {
    @Override
    public void provide(SelFuncRegistry registry) {
        for (var type : List.of(SelTypes.GRAPH_DATA, SelTypes.BOOLEAN, SelTypes.DOUBLE, SelTypes.STRING)) {
            SelTypeVector vectorType = new SelTypeVector(type);
            registry.add(SelFunc.newBuilder()
                .name("to_vector")
                .category(SelFuncCategory.OTHER)
                .help("convert element or vector of elements to vector of elements")
                .args(type)
                .returnType(vectorType)
                .handler(args -> {
                    SelValue selValue = args.get(0);
                    if (type.isDouble()) {
                        double value = selValue.castToScalar().getValue();
                        return new SelValueVector(new double[]{value});
                    }
                    return new SelValueVector(type, new SelValue[] {selValue});
                })
                .build());
            registry.add(SelFunc.newBuilder()
                .name("to_vector")
                .category(SelFuncCategory.OTHER)
                .help("convert element or vector of elements to vector of elements")
                .args(vectorType)
                .returnType(vectorType)
                .handler(args -> args.get(0))
                .build());
        }
    }
}
