package ru.yandex.solomon.expression.expr.func.util;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.exceptions.EvaluationException;
import ru.yandex.solomon.expression.expr.func.DoubleSelFn;
import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;
import ru.yandex.solomon.expression.expr.func.SelFuncProvider;
import ru.yandex.solomon.expression.expr.func.SelFuncRegistry;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.ArgsList;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueGraphData;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.model.timeseries.GraphData;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelFnTransform implements SelFuncProvider {
    private static DoubleSelFn getTransformFunction(ArgsList args) {
        String fnName = args.get(1).castToString().getValue();

        return DoubleSelFn.Type
            .byName(fnName)
            .map(DoubleSelFn.Type::getFunc)
            .orElseThrow(() -> new EvaluationException(args.getRange(1), "Not found arithmetical function with name: " + fnName));
    }

    private static NamedGraphData calculate(NamedGraphData namedGraphData, DoubleSelFn func) {
        GraphData result = namedGraphData.getGraphData().mapValues(func::eval);
        return namedGraphData.toBuilder()
            .setGraphData(result)
            .build();
    }

    @Override
    public void provide(SelFuncRegistry registry) {
        registry.add(SelFunc.newBuilder()
            .name("transform")
            .help("Deprecated. Apply transform function to graph")
            .category(SelFuncCategory.DEPRECATED)
            .args(SelTypes.GRAPH_DATA, SelTypes.STRING)
            .returnType(SelTypes.GRAPH_DATA)
            .handler(args -> {
                var source = args.get(0).castToGraphData().getNamedGraphData();
                var func = getTransformFunction(args);

                return new SelValueGraphData(calculate(source, func));
            })
            .build());

        registry.add(SelFunc.newBuilder()
            .name("transform")
            .help("Deprecated. Apply transform function to graph")
            .category(SelFuncCategory.DEPRECATED)
            .args(SelTypes.GRAPH_DATA_VECTOR, SelTypes.STRING)
            .returnType(SelTypes.GRAPH_DATA_VECTOR)
            .handler(args -> {
                var source = args.get(0).castToVector().valueArray();
                var func = getTransformFunction(args);

                var result = new SelValue[source.length];
                for (int index = 0; index < source.length; index++) {
                    var item = source[index].castToGraphData().getNamedGraphData();
                    result[index] = new SelValueGraphData(calculate(item, func));
                }

                return new SelValueVector(SelTypes.GRAPH_DATA, result);
            })
            .build());
    }
}
