package ru.yandex.solomon.expression.expr.op.bin;

/**
 * @author Vladimir Gordiychuk
 */
public enum CompareBinOp {
    EQ("equal", "==") {
        @Override
        boolean applyDouble(double left, double right) {
            return left == right;
        }

        @Override
        boolean applyString(String left, String right) {
            return left.equals(right);
        }
    },
    NE("not_equal", "!=") {
        @Override
        boolean applyDouble(double left, double right) {
            return left != right;
        }

        @Override
        boolean applyString(String left, String right) {
            return !left.equals(right);
        }
    },
    LT("less", "<") {
        @Override
        boolean applyDouble(double left, double right) {
            return left < right;
        }

        @Override
        boolean applyString(String left, String right) {
            return left.compareTo(right) < 0;
        }
    },
    LE("less_or_equal", "<=") {
        @Override
        boolean applyDouble(double left, double right) {
            return left <= right;
        }

        @Override
        boolean applyString(String left, String right) {
            return left.compareTo(right) <= 0;
        }
    },
    GT("great", ">") {
        @Override
        boolean applyDouble(double left, double right) {
            return left > right;
        }

        @Override
        boolean applyString(String left, String right) {
            return left.compareTo(right) > 0;
        }
    },
    GE("great_or_equal", ">=") {
        @Override
        boolean applyDouble(double left, double right) {
            return left >= right;
        }

        @Override
        boolean applyString(String left, String right) {
            return left.compareTo(right) >= 0;
        }
    };

    public final String name;
    public final String operator;

    CompareBinOp(String name, String operator) {
        this.name = name;
        this.operator = operator;
    }

    abstract boolean applyDouble(double left, double right);

    abstract boolean applyString(String left, String right);
}
